/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.List;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class WelcomeMessageScreen
extends Screen {
    private final Screen lastScreen;
    private final Component text;
    @Nullable
    private final Component url;
    private final Runnable onTurnOff;
    private int ticksUntilEnable;
    private MultiLineLabel message = MultiLineLabel.EMPTY;
    private MultiLineLabel suggestions = MultiLineLabel.EMPTY;
    private Button exitButton;
    private Button disaleButton;
    private static final Component OF_TEXT = Component.translatable((String)"gui.supplementaries.optifine.message");
    private static final Component OF_URL = Component.translatable((String)"gui.supplementaries.optifine.suggestions").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).applyFormat(ChatFormatting.UNDERLINE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.alternatives.lambdaurora.dev/")));
    private static final Component OF_TITLE = Component.translatable((String)"gui.supplementaries.optifine.title").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD);
    private static final Component AM_TEXT = Component.translatable((String)"gui.supplementaries.amendments.message");
    private static final Component AM_URL = Component.translatable((String)"gui.supplementaries.amendments.suggestions").withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).applyFormat(ChatFormatting.UNDERLINE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://legacy.curseforge.com/minecraft/mc-mods/amendments")));
    private static final Component AM_TITLE = Component.translatable((String)"gui.supplementaries.amendments.title").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
    private static final Component IM_TITLE = Component.translatable((String)"gui.supplementaries.incompatible_mods.title").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
    private static final List<String> MODS_WITH_KNOWN_ISSUES = List.of();
    private static final String IM_LIST = MODS_WITH_KNOWN_ISSUES.stream().filter(PlatHelper::isModLoaded).collect(Collectors.joining(", "));

    public WelcomeMessageScreen(Screen screen, int ticksUntilEnable, Component title, Component text, @Nullable Component url, Runnable onTurnOff) {
        super(title);
        this.lastScreen = screen;
        this.ticksUntilEnable = ticksUntilEnable;
        this.text = text;
        this.url = url;
        this.onTurnOff = onTurnOff;
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.text});
    }

    protected void init() {
        super.init();
        this.exitButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_PROCEED, pressed -> Minecraft.getInstance().setScreen(this.lastScreen)).bounds(this.width / 2 + 5, this.height * 5 / 6, 150, 20).build());
        this.exitButton.active = false;
        this.disaleButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.supplementaries.welcome_screen.turn_off"), pressed -> {
            Minecraft.getInstance().setScreen(this.lastScreen);
            this.onTurnOff.run();
        }).bounds(this.width / 2 - 155, this.height * 5 / 6, 150, 20).build());
        this.disaleButton.active = false;
        this.message = MultiLineLabel.create((Font)this.font, (Component)this.text, (int)(this.width - 50));
        this.suggestions = this.url == null ? MultiLineLabel.EMPTY : MultiLineLabel.create((Font)this.font, (Component)this.url, (int)(this.width - 50));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 30, 0xFFFFFF);
        this.message.renderCentered(graphics, this.width / 2, 55);
        this.suggestions.renderCentered(graphics, this.width / 2, 180);
    }

    public void tick() {
        super.tick();
        if (--this.ticksUntilEnable <= 0) {
            this.exitButton.active = true;
            this.disaleButton.active = true;
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.ticksUntilEnable <= 0;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pMouseY > 180.0 && pMouseY < 190.0 && this.url != null) {
            Style style = this.getClickedComponentStyleAt((int)pMouseX);
            if (this.url != null && style != null && style.getClickEvent() != null && style.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL) {
                this.handleComponentClicked(style);
                return false;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    @Nullable
    private Style getClickedComponentStyleAt(int xPos) {
        int wid = Minecraft.getInstance().font.width((FormattedText)this.url);
        int left = this.width / 2 - wid / 2;
        int right = this.width / 2 + wid / 2;
        return xPos >= left && xPos <= right ? Minecraft.getInstance().font.getSplitter().componentStyleAtWidth((FormattedText)this.url, xPos - left) : null;
    }

    public static WelcomeMessageScreen createOptifine(Screen screen) {
        return new WelcomeMessageScreen(screen, 200, OF_TITLE, OF_TEXT, OF_URL, () -> SuppPlatformStuff.disableOFWarn(true));
    }

    public static WelcomeMessageScreen createAmendments(Screen screen) {
        return new WelcomeMessageScreen(screen, 100, AM_TITLE, AM_TEXT, AM_URL, SuppPlatformStuff::disableAMWarn);
    }

    public static WelcomeMessageScreen createIncompatibleMods(Screen screen) {
        return new WelcomeMessageScreen(screen, 60, IM_TITLE, (Component)Component.translatable((String)"gui.supplementaries.incompatible_mods.message", (Object[])new Object[]{Component.literal((String)IM_LIST).withStyle(ChatFormatting.RED)}), null, SuppPlatformStuff::disableIMWarn);
    }

    public static boolean hasIncompat() {
        for (String s : MODS_WITH_KNOWN_ISSUES) {
            if (!PlatHelper.isModLoaded((String)s)) continue;
            return true;
        }
        return false;
    }
}

